E4C90L40.R GISS Model E  1850 ocn/atm                 rar 07/15/2009

E4C90L40 = E4F40 on cubed sphere grid 6x90x90 grid boxes
E4F40 = modelE as frozen in April 2010:
Cubed Sphere grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)
atmospheric composition from year 1850
ocean data: prescribed, 1876-1885 climatology
uses turbulence scheme (no dry conv), grav.wave drag
time steps: dynamics: finite Volume ; physics 30 min.; radiation 2.5 hrs
filters: none

Preprocessor Options
!#define TRACERS_ON                  ! include tracers code
#define USE_ENT
#define NEW_IO
#define CALC_GWDRAG
#define SET_SOILCARBON_GLOBAL_TO_ZERO
End Preprocessor Options

Object modules:
     ! resolution-specific source codes
RES_CS90L40                         ! C90 horiz. resolution, top at 0.1mb, 40 layers

     ! Codes used by the cubed-atmosphere configuration (FV dynamics)
#include "cubed_sphere_source_files"

STRATDYN STRAT_DIAG                 ! stratospheric dynamics (incl. gw drag)
#include "modelE4_source_files"
#include "static_ocn_source_files"

Components:
#include "E4_components"    /* without "Ent" */
Ent
dd2d

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB    /* needed for "Ent" only */
OPTS_giss_LSM = USE_ENT=YES           /* needed for "Ent" only */
OPTS_dd2d = NC_IO=PNETCDF
FVCUBED = YES

Data input files:
#include "IC_CS90_input_files"
#include "static_ocn_1880_CS90_input_files"

RVR=RDdistocean_CS90_EM.bin         ! river direction file

#include "landCS90_input_files"
#include "rad_input_files"
#include "TAero2008_input_files"
#include "O3_2005_input_files"

MSU_wts=MSU.RSS.weights.data     ! MSU-diag
REG=REG.txt                      ! special regions-diag

Label and Namelist:  (next 2 lines)
E4C90L40 (AR5 base run C90L40)


&&PARAMETERS
#include "static_ocn_params"

#include "sdragCS90_params"
#include "gwdragCS90_params"

! cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! Increasing U00a decreases the high cloud cover; increasing U00b decreases net rad at TOA
U00a=0.60 ! above 850mb w/o MC region;  tune this first to get 30-35% high clouds
U00b=1.10 ! below 850mb and MC regions; tune this last  to get rad.balance

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

DTsrc=1800.      ! cannot be changed after a run has been started
DT=1800.         ! for FV dynamics, set same as DTsrc

NIsurf=1         ! (surf.interaction NIsurf times per physics time step)
NRAD=5           ! radiation (every NRAD'th physics time step)

#include "diag_params"

Nssw=2           ! until diurnal diags are fixed, Nssw has to be even
Ndisk=960
&&END_PARAMETERS

 &INPUTZ
 YEARI=1949,MONTHI=12,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
 YEARE=1949,MONTHE=12,DATEE=2,HOURE=0,     KDIAG=12*0,9,
 ISTART=2,IRANDI=0, YEARE=1949,MONTHE=12,DATEE=1,HOURE=1,
 &END
