/*! \file Contour.c
 *  \sa Contour.h
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./objects.h"
#include "../include/include.h"
#include "../io/io.h"

/*Contour constructors and destructors:*/
/*FUNCTION Contour::Contour() default constructor {{{1*/
Contour::Contour(){
	this->id=0;
	this->nods=0;
	this->x=NULL;
	this->y=NULL;
	this->closed=false;
}
/*}}}*/
/*FUNCTION Contour::Contour(int pid, int nods, double* x, double* y,bool closed) {{{1*/
Contour::Contour(int pid,int pnods, double* px, double* py,bool pclosed){
	
	this->id=pid;
	this->nods=pnods;
	this->closed=pclosed;
	if(nods){
		this->x=(double*)xmalloc(nods*sizeof(double));
		memcpy(this->x,px,nods*sizeof(double));
		this->y=(double*)xmalloc(nods*sizeof(double));
		memcpy(this->y,py,nods*sizeof(double));
	}
}
/*}}}*/
/*FUNCTION Contour::Contour() default constructor {{{1*/
Contour::~Contour(){
	xfree((void**)&this->x);
	xfree((void**)&this->y);
}
/*}}}*/


/*Object virtual function resolutoin: */
/*FUNCTION Contour::Echo(){{{1*/
void Contour::Echo(void){

	int i;

	printf("Contour: %i:\n",id);
	printf("   nods: %i\n",nods);
	printf("   closed: %s\n",closed?"true":"false");
	if(nods){
		printf("   x,y:\n");
		for(i=0;i<nods;i++){
			printf("%i: %g|%g\n",i,x[i],y[i]);
		}
	}
}
/*}}}*/
/*FUNCTION Contour::DeepEcho(){{{1*/
void Contour::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Contour::Id(){{{1*/
int Contour::Id(void){
	return id;
}
/*}}}*/
/*FUNCTION Contour::MyRank{{{1*/
int    Contour::MyRank(void){ 
	extern int my_rank;

	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION Contour::Marshall{{{1*/
void  Contour::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;
	char* marshalled_inputs=NULL;
	int   marshalled_inputssize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Contour: */
	enum_type=ContourEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Contour data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&nods,sizeof(nods));marshalled_dataset+=sizeof(nods);
	memcpy(marshalled_dataset,&closed,sizeof(closed));marshalled_dataset+=sizeof(closed);
	memcpy(marshalled_dataset,x,nods*sizeof(double));marshalled_dataset+=nods*sizeof(double);
	memcpy(marshalled_dataset,y,nods*sizeof(double));marshalled_dataset+=nods*sizeof(double);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION Contour::MarshallSize{{{1*/
int   Contour::MarshallSize(){

	return sizeof(id)+
		sizeof(nods)+
		sizeof(closed)+
		2*nods*sizeof(double)+
		sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION Contour::Demarshall{{{1*/
void  Contour::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&nods,marshalled_dataset,sizeof(nods));marshalled_dataset+=sizeof(nods);
	memcpy(&closed,marshalled_dataset,sizeof(closed));marshalled_dataset+=sizeof(closed);

	if(nods){
		this->x=(double*)xmalloc(nods*sizeof(double));
		this->y=(double*)xmalloc(nods*sizeof(double));
		memcpy(x,marshalled_dataset,nods*sizeof(double));marshalled_dataset+=nods*sizeof(double);
		memcpy(y,marshalled_dataset,nods*sizeof(double));marshalled_dataset+=nods*sizeof(double);
	}

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION Contour::ObjectEnum{{{1*/
int Contour::ObjectEnum(void){

	return ContourEnum;

}
/*}}}*/
/*FUNCTION Contour::copy {{{1*/
Object* Contour::copy() {

	return new Contour(*this); 

}
/*}}}*/
