#module imports
from fielddisplay import fielddisplay

class initialization:
	#properties
	def __init__(self):
		# {{{ Properties
		
		self.vx            = float('NaN')
		self.vy            = float('NaN')
		self.vz            = float('NaN')
		self.vel           = float('NaN')
		self.pressure      = float('NaN')
		self.temperature   = float('NaN')
		self.watercolumn   = float('NaN')
		self.waterfraction = float('NaN')
		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   initial field values:'

		string="%s\n%s"%(string,fielddisplay(obj,'vx','x component of velocity'))
		string="%s\n%s"%(string,fielddisplay(obj,'vy','y component of velocity'))
		string="%s\n%s"%(string,fielddisplay(obj,'vz','z component of velocity'))
		string="%s\n%s"%(string,fielddisplay(obj,'vel','velocity norm'))
		string="%s\n%s"%(string,fielddisplay(obj,'pressure','pressure field'))
		string="%s\n%s"%(string,fielddisplay(obj,'temperature','temperature in Kelvins'))
		string="%s\n%s"%(string,fielddisplay(obj,'watercolumn','thickness of subglacial water'))
		string="%s\n%s"%(string,fielddisplay(obj,'waterfraction','fraction of water in the ice'))

		return string
		#}}}
