#PETSCVERSION - recover petsc version number, inside config.h file
#
#   Usage:
#       PETSC_VERSION=petscversion();

#Module imports {{{
import os
import sys
from issmtier import *
#}}}

def petscversion():

	#default
	PETSC_VERSION=3;
	
	configfile=issmtier() + "/bin/config.h" #should find it in the install target
	
	if not os.path.isfile(configfile):
		raise RuntimeError("%s%s%s"%("File ",configfile," not found. ISSM has not been configured yet!"))

	#go through the file, and recover the line we want
	fid=open(configfile,'r');

	tline=fid.readline()
	while tline:

		if tline=='': 
			break
		
		if tline[0:21]=="#define _PETSC_MAJOR_":
			PETSC_VERSION=int(tline[22])
			break
		
		tline=fid.readline()
	
	fid.close();

	return PETSC_VERSION
