/*\file CreateJacobianMatrix.c
 *\brief: build system matrices (stiffness matrix, loads vector)
 */

#include "./CreateJacobianMatrix.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Loads      *loads      = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	double kmax;
	
	/* output datasets: */
	Matrix*    Jff  = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CreateJacobianMatrixUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchData(&parameters,PARAMETERS);
	FetchData(&kmax,KMAX);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);
	materials-> Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	CreateJacobianMatrixx(&Jff,elements,nodes,vertices,loads,materials,parameters,kmax);

	/*write output datasets: */
	WriteData(JFF,Jff);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	delete Jff;

	/*end module: */
	MODULEEND();
}

void CreateJacobianMatrixUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [Jff] = %s(elements,nodes,vertices,loads,materials,parameters,kmax);\n",__FUNCT__);
	_printf_(true,"\n");
}
