/*\file NodesDof.c
 *\brief: build degrees of freedom for every grid.
 */

#include "./NodesDof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;
	int     analysis_type;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&NodesDofUsage);

	/*Input datasets: */
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData(&parameters,PARAMETERS);

	/*find analysis_type: */
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*!Generate internal degree of freedom numbers: */
	NodesDofx(nodes, parameters,analysis_type); 

	/*write output datasets: */
	WriteData(NODES,nodes);

	/*Free ressources: */
	delete nodes;
	delete parameters;
	/*end module: */
	MODULEEND();
}

void NodesDofUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [nodes] = %s(nodes,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
