# This makefile configures build process to cross-compile to the android platform.
# The binary tools referenced below are specifically configuered to target armeabi-v7a.
# Furthermore, the compilers (which are simply wrappers around GNU GCC) are set to
# produce binaries that are EABI complient.
#
# Note that the AAPCS standard defines 'EABI' as a moniker used to specify
# a _family_ of similar but distinct ABIs. Android follows the little-endian
# ARM GNU/Linux ABI as documented in the following document:
#
# http://www.codesourcery.com/gnu_toolchains/arm/arm_gnu_linux_abi.pdf

ANDROID_BIN=$(ISSM_TIER)/src/android/tmp/android-14-toolchain/bin
CC=$(ANDROID_DEV_DIR)/tmp/android-linux-4.0/bin/arm-linux-androideabi-gcc
AR=$(ANDROID_DEV_DIR)/tmp/android-linux-4.0/bin/arm-linux-androideabi-ar
RANLIB=$(ANDROID_DEV_DIR)/tmp/android-linux-4.0/bin/arm-linux-androideabi-ranlib
CSWITCHES = $(CFLAGS)  -I/usr/X11R6/include -L/usr/X11R6/lib -I$(MATLAB_DIR)/extern/include -fPIC -I$(MATLAB_DIR)/include
TRILIBDEFS = -DTRILIBRARY
OBJ_EXT=o
LIB_EXT=a
