#!/bin/bash

#remove previous doc
rm -rf "$ISSM_DIR/doc/website/doc_m/matlabhtml"

#copy issm_template in m2html
cd "$ISSM_DIR/packages/m2html/install/templates"
ln -s "$ISSM_DIR/doc/website/doc_m/template_issm" ./template_issm

#go to the main directory
cd $ISSM_DIR

#launch matlab
matlab -nodisplay << EOF
%get ISSM_DIR, brief name
[status,ISSM_DIR_BRIEF]=system('basename `pwd`');
ISSM_DIR_BRIEF=ISSM_DIR_BRIEF(1:end-1); %skip the \n character
if status~=0 | isempty(ISSM_DIR_BRIEF) | length(ISSM_DIR_BRIEF)==1,
	error('startup error message: could not retrieve ISSM_DIR brief name');
	end

	cd ../

	%Here are the subdirectories we want to go through:
	mfiles={[ISSM_DIR_BRIEF '/src/m']};
	%mfiles={[ISSM_DIR_BRIEF '/src/m/classes/public/plot']};

	%run m2html, and dump the documentation in ISSM_DIR/doc/website/doc_m/matlabhtml
	m2html('htmldir',[ISSM_DIR '/doc/website/doc_m/matlabhtml'],'recursive','on','source','on','syntaxHighlighting','on','globalHypertextLinks','on','global','on','template','template_issm', 'index','menu','mFiles',mfiles);
EOF

#remove soft link
rm "$ISSM_DIR/packages/m2html/install/templates/template_issm"
