#module imports
from fielddisplay import fielddisplay

class thermal:
	#properties
	def __init__(self):
		# {{{ Properties
		self.spctemperature    = float('NaN')
		self.penalty_threshold = 0
		self.stabilization     = 0
		self.maxiter           = 0
		self.penalty_lock      = 0
		self.penalty_factor    = 0
		self.isenthalpy        = 0
		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   Thermal solution parameters:'
		string="%s\n\n%s"%(string,fielddisplay(obj,'spctemperature','temperature constraints (NaN means no constraint)'))
		string="%s\n%s"%(string,fielddisplay(obj,'stabilization','0->no, 1->artificial_diffusivity, 2->SUPG'))
		string="%s\n%s"%(string,fielddisplay(obj,'maxiter','maximum number of non linear iterations'))
		string="%s\n%s"%(string,fielddisplay(obj,'penalty_lock','stabilize unstable thermal constraints that keep zigzagging after n iteration (default is 0, no stabilization)'))
		string="%s\n%s"%(string,fielddisplay(obj,'penalty_threshold','threshold to declare convergence of thermal solution (default is 0)'))
		string="%s\n%s"%(string,fielddisplay(obj,'isenthalpy','use an enthalpy formulation to include temperate ice (default is 0)'))
		return string
		#}}}
