#module imports
from fielddisplay import fielddisplay

class hydrology:
	#properties
	def __init__(self):
		# {{{ Properties
		self.spcwatercolumn = float('NaN')
		self.n              = 0
		self.CR             = 0
		self.p              = 0
		self.q              = 0
		self.kn             = 0
		self.stabilization  = 0
	
		#}}}
	def __repr__(obj):
		# {{{ Display
		
		string='   hydrology solution parameters:'
		string="%s\n\n%s"%(string,fielddisplay(obj,'spcwatercolumn','water thickness constraints (NaN means no constraint)'))
		string="%s\n%s"%(string,fielddisplay(obj,'n','Manning roughness coefficient'))
		string="%s\n%s"%(string,fielddisplay(obj,'CR','tortuosity parameter'))
		string="%s\n%s"%(string,fielddisplay(obj,'p','dimensionless exponent in Manning velocity formula'))
		string="%s\n%s"%(string,fielddisplay(obj,'q','dimensionless exponent in Manning velocity formula'))
		string="%s\n%s"%(string,fielddisplay(obj,'kn','parameter in effective pressure formula'))
		string="%s\n%s"%(string,fielddisplay(obj,'stabilization','artificial diffusivity (default is 1). can be more than 1 to increase diffusivity.'))
		return string
		#}}}
