/*\file VerticesDof.c
 *\brief: build degrees of freedom for every vertex
 */

#include "./VerticesDof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vertices* vertices=NULL;
	Parameters* parameters=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&VerticesDofUsage);

	/*Input datasets: */
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData(&parameters,PARAMETERS);

	/*!Generate internal degree of freedom numbers: */
	VerticesDofx(vertices, parameters); 

	/*write output datasets: */
	WriteData(VERTICES,vertices);

	/*Free ressources: */
	delete vertices;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void VerticesDofUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [vertices] = %s(vertices,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
