/*\file ResetCoordinateSystem.c
 *\brief: recover pressure from elements
 */

#include "./ResetCoordinateSystem.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL; 
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      numberofnodes;

	/* output datasets: */
	Vector* sigma_g=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ResetCoordinateSystemUsage);
        
	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchData(&parameters,PARAMETERS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	ResetCoordinateSystemx(elements,nodes,vertices,loads,materials,parameters);

	/*write output datasets: */
	WriteData(NODESOUT,nodes);

	/*Free ressources: */
	delete nodes;
	delete vertices;
	delete elements;
	delete materials;
	delete loads;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ResetCoordinateSystemUsage(void) {
	printf("\n");
	printf("   usage: [nodes] = %s(elements, nodes, vertices, loads, materials, params);\n",__FUNCT__);
	printf("\n");
}
