/*\file Reduceload.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceload.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vector*         pf         = NULL;
	Matrix*         Kfs        = NULL;
	Vector*         ys         = NULL;
	bool        flag_ys0=false;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=3 && nrhs!=4)){
		ReduceloadUsage();
		_error_(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&pf,PF);
	FetchData(&Kfs,KFS);
	FetchData(&ys,YS);

	/*!Reduce load from g to f size: */
	if(nrhs==4){
		FetchData(&flag_ys0,YSFLAG);
		Reduceloadx(pf, Kfs, ys,flag_ys0);
	}
	else{
		Reduceloadx(pf, Kfs, ys);
	}

	/*write output datasets: */
	WriteData(PFOUT,pf);

	/*Free ressources: */
	xdelete(&pf);
	xdelete(&Kfs);
	xdelete(&ys);

	MODULEEND();
}

void ReduceloadUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [pf] = %s(pf,Kfs,ys);\n",__FUNCT__);
	_printf_(true,"          [pf] = %s(pf,Kfs,ys,ys0_flag);\n",__FUNCT__);
	_printf_(true,"\n");
}
