/*! \file  PointCloudFindNeighbors
    \brief: flag points that are too near one another, within an array of point coordinates
*/
	
#include "./PointCloudFindNeighbors.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) {

	int i,j;

	/* required input: */
	double* x=NULL;
	double* y=NULL;
	int     nods;
	double  mindistance;
	double  multithread;

	/* output: */
	Vector*  flags=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PointCloudFindNeighborsUsage);

	/*Fetch inputs: */
	FetchData(&x,&nods,NULL,XHANDLE);  
	FetchData(&y,NULL,NULL,YHANDLE);
	FetchData(&mindistance,MINDISTANCE);
	FetchData(&multithread,MULTITHREAD);

	/*Run core routine: */
	PointCloudFindNeighborsx(&flags,x,y,nods,mindistance,multithread);

	/* output: */
	WriteData(FLAGS,flags);

	/*end module: */
	MODULEEND();
}

void PointCloudFindNeighborsUsage(void){
	printf("   usage:\n");
	printf("   [flags]=PointCloudFindNeighbors(x,y,mindistance,multithread);\n\n");
	printf("   where:\n");
	printf("      x,y: list of points.\n");
	printf("      mindistance: minimum distance that should exist between points in the cloud.\n");
	printf("      multithread: run multithreaded or not. with multithreads, flags can get 1 and 2 values in duplicates.\n");
	printf("      flags: array of flags (flag==1 means point is within mindistance of another point)\n");
	printf("\n");
}
