/*\file InputUpdateFromVector.c
*\brief: update elements properties using an input  vector
*/

#include "./InputUpdateFromVector.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	double*  vector=NULL;
	int      dummy;
	int      name;
	int      type;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputUpdateFromVectorUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALSIN);
	FetchData(&parameters,PARAMETERSIN);
	FetchData(&vector,&dummy,VECTOR);
	FetchData(&name,NAME);
	FetchData(&type,TYPE);

	/*Check that type is one of Constant, Vertex or Element: */
	if ((type!=ConstantEnum) && (type!=VertexEnum) && (type!=ElementEnum)){
		_error_("%s%s%s\n","Type of input can only be a constant, a vertex or an element vector.  Right now, you input a ",EnumToStringx(type)," type data for input update");
	}

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Generate internal degree of freedom numbers: */
	InputUpdateFromVectorx(elements,nodes,vertices,loads, materials,parameters,vector,name,type);

	/*write output datasets: */
	WriteData(ELEMENTS,elements);
	WriteData(NODES,nodes);
	WriteData(VERTICES,vertices);
	WriteData(LOADS,loads);
	WriteData(MATERIALS,materials);
	WriteData(PARAMETERS,parameters);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&vector);

	/*end module: */
	MODULEEND();
}

void InputUpdateFromVectorUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,parameters,vector,name_enum,type_enum);\n",__FUNCT__);
	_printf_(true,"\n");
}
