function femmodel=thermal_core(femmodel)
%THERMAL_CORE - core of thermal solution
%
%   Usage:
%      femmodel=thermal_core(femmodel)


	%recover parameters common to all solutions
	save_results=femmodel.parameters.SaveResults;

	issmprintf(VerboseSolution,'\n%s',['   computing temperature']);
	femmodel=SetCurrentConfiguration(femmodel,ThermalAnalysisEnum);
	femmodel=solver_thermal_nonlinear(femmodel);

	issmprintf(VerboseSolution,'\n%s',['   computing melting']);
	femmodel=SetCurrentConfiguration(femmodel,MeltingAnalysisEnum);
	femmodel=solver_linear(femmodel);

	if (save_results),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BasalforcingsMeltingRateEnum);
	end

end %end of function
