function femmodel=surfaceslope_core(femmodel)
%SURFACESLOPE_CORE - core of the surface slope computation solution
%
%   Usage:
%      femmodel=surfaceslope_core(femmodel)
%

	%Recover some parameters:
	save_results=femmodel.parameters.SaveResults;

	%Call on core computations: 
	issmprintf(VerboseSolution,'\n%s',['   computing surface slope']);
	femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	if (save_results),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
	end

end %end function
