function femmodel=balancethickness_core(femmodel)
%BALANCEDTHICKNESS_CORE - linear solution sequence
%
%   Usage:
%      femmodel=balancethickness_core(femmode)

	%recover parameters common to all solutions
	save_results=femmodel.parameters.SaveResults;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,BalancethicknessAnalysisEnum);

	issmprintf(VerboseSolution,'   call computational core');
	femmodel=solver_linear(femmodel);

	if (save_results),
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum);
	end
	
end %end function
