/*!\file:  PetscOptionsFromAnalysis.cpp
 * \brief: change petsc options using analysis type and parameters
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../Container/Parameters.h"
#include "../../toolkits/toolkits.h"

void PetscOptionsFromAnalysis(Parameters* parameters,int analysis_type){

	/*intermediary: */
	char* options=NULL;

	/*Recover first the options string for this analysis: */
	options=OptionsFromAnalysis(parameters,analysis_type);

	/*now, reset the options database with this string. Taken from petsc/install/src/sys/objects/pinit.c. This 
	 *capability is not covered by Petsc!: */

	#if _PETSC_MAJOR_ == 2 
	PetscOptionsDestroy();
	PetscOptionsCreate();
	//PetscOptionsCheckInitial_Private();
	//PetscOptionsCheckInitial_Components();
	PetscOptionsSetFromOptions();
	PetscOptionsInsertMultipleString(options); //our patch
	#else
	PetscOptionsSetFromOptions();
	PetscOptionsClear();
	//PetscOptionsSetFromOptions();
	PetscOptionsInsertMultipleString(options); //our patch
	#endif

	/*Free ressources:*/
	xfree((void**)&options);
}
