/*!\file:  BamgGeom.h
 */ 

#ifndef _BAMGGEOM_H_
#define _BAMGGEOM_H_

#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
#include <mex.h>
#endif

class BamgGeom{

	public:
		int     VerticesSize[2];
		double* Vertices;
		int     EdgesSize[2];
		double* Edges;
		int     TangentAtEdgesSize[2];
		double* TangentAtEdges;
		int     CornersSize[2];
		double* Corners;
		int     RequiredVerticesSize[2];
		double* RequiredVertices;
		int     RequiredEdgesSize[2];
		double* RequiredEdges;
		int     CrackedEdgesSize[2];
		double* CrackedEdges;
		int     SubDomainsSize[2];
		double* SubDomains;

		BamgGeom();
		#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
		BamgGeom(mxArray* matlab_struct);
		#endif
		~BamgGeom();

		#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
		void SetMatlabStructureFields(mxArray** matlab_struct);
		void SetMatlabStructureField(mxArray* matlab_struct,const char* fieldname,int fieldrows,int fieldcols,double* fieldpointer);
		#endif
};

#endif
