#!/bin/sh

#petsc 3.2
#mpich 1.4

./configure \
	--with-serial=no\
	--prefix=$ISSM_TIER \
	--with-metis-dir=$ISSM_TIER/externalpackages/metis/install \
	--with-mpi-include=$ISSM_TIER/externalpackages/mpich2/install/include  \
	--with-mpi-lib=" $ISSM_TIER/externalpackages/mpich2/install/lib/libpmpich.a $ISSM_TIER/externalpackages/mpich2/install/lib/libmpich.a $ISSM_TIER/externalpackages/mpich2/install/lib/libmpl.a " \
	--without-blas-lapack-dir \
	--with-chaco-dir=$ISSM_TIER/externalpackages/chaco/install \
	--with-fortran-lib="/usr/local/gfortran/lib/libgfortran.a" \
	--with-dakota-dir=$ISSM_TIER/externalpackages/dakota/install \
	--with-math-lib="/usr/lib/libm.dylib" \
	--with-graphics-lib="/usr/X11/lib/libX11.dylib" \
	--with-cxxoptflags=" -fno-common -no-cpp-precomp -fexceptions -arch x86_64 -mmacosx-version-min=10.5  -O3 -DNDEBUG -w "\
	--with-adic2-dir=$ISSM_TIER/externalpackages/adic/install/ \
	--with-adolc-dir=$ISSM_TIER/externalpackages/adolc/install/ \
	--with-numthreads=8 \
	--without-thermal \
	--without-control \
	--without-hydrology \
	--without-diagnostic \
	--without-balanced \
	--without-responses \
	--without-slope \
	--without-rifts \
	--without-steadystate \
	--without-transient \
	--without-3d \
	--without-groundingline
 
#--without-prognostic \
#--with-petsc-dir=$ISSM_TIER/externalpackages/petsc/install  \
#--with-petsc-arch=$ISSM_ARCH \
#--with-blas-lapack-dir=$ISSM_TIER/externalpackages/petsc/install \
#--with-plapack-lib="-L$ISSM_TIER/externalpackages/petsc/install/ -lPLAPACK" \
#--with-plapack-include="-I$ISSM_TIER/externalpackages/petsc/install/include/ " \
#--with-blacs-dir=$ISSM_TIER/externalpackages/petsc/install/ \
#--with-scalapack-dir=$ISSM_TIER/externalpackages/petsc/install/ \
#--with-mumps-dir=$ISSM_TIER/externalpackages/petsc/install/ \
