#ISMUMPS - figure out if MUMPS package was compiled with ISSM
#
#   Usage:
#       flag=ismumps();

#Module imports {{{
import os
import sys
from issmtier import *
#}}}

def ismumps():

	configfile=issmtier() + "/bin/config.h" #should find it in the install target
	
	if not os.path.isfile(configfile):
		raise RuntimeError("%s%s%s"%("File ",configfile," not found. ISSM has not been configured yet!"))
	
	#%go through the file, and recover the line we want
	flag=2;
	fid=open(configfile,'r');

	tline=fid.readline()
	while tline:
		
		if tline=='': 
			break
		if tline[0:25]=="/* #undef _HAVE_MUMPS_ */":
			flag=0;
			break
		if tline[0:20]=="#define _HAVE_MUMPS_":
			flag=1
			break
		tline=fid.readline()

	fid.close();

	if flag==2:
		raise RuntimeError('could not determine whether MUMPS was or was not compiled')

	return flag
