#module imports {{{
from pairoptions import *
from petscversion  import *
#}}}
def mumpsoptions(*args):
	#MUMPSOPTIONS - return MUMPS direct solver  petsc options
	#
	#   Usage:
	#      options=mumpsoptions;
	
	#retrieve options provided in varargin
	arguments=pairoptions(*args) 


	#default mumps options
	PETSC_VERSION=petscversion()

	if PETSC_VERSION==2:
		options=[['mat_type','aijmumps'],['ksp_type','preonly'],['pc_type','lu'],['mat_mumps_icntl_14',120],['pc_factor_shift_positive_definite','true']]
	if PETSC_VERSION==3:
		options=[['mat_type','mpiaij'],['ksp_type','preonly'],['pc_type','lu'],['pc_factor_mat_solver_package','mumps'],['mat_mumps_icntl_14',120],['pc_factor_shift_positive_definite','true']]

	#now, go through our arguments, and write over default options.
	for i in range(len(arguments.list)):
		arg1=arguments.list[i][0]
		arg2=arguments.list[i][1]
		found=0;
		for j in range(len(options)):
			joption=options[j][0]
			if joption==arg1:
				joption[1]=arg2;
				options[j]=joption;
				found=1;
				break
		if not found:
			#this option did not exist, add it: 
			options.append([arg1,arg2])
	return options
