#module imports
from fielddisplay import fielddisplay

class transient:
	#properties
	def __init__(self):
		# {{{ Properties
		self.isprognostic      = 0
		self.isdiagnostic      = 0
		self.isthermal         = 0
		self.isgroundingline   = 0
		self.requested_outputs = float('NaN')
		#}}}
	def __repr__(obj):
		# {{{ Display
		string='   transient solution parameters:'
		string="%s\n%s"%(string,fielddisplay(obj,'isprognostic','indicates if a prognostic solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'isthermal','indicates if a thermal solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'isdiagnostic','indicates if a diagnostic solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'isgroundingline','indicates if a groundingline migration is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(obj,'requested_outputs','list of additional outputs requested'))
		return string
		#}}}
