/*\file GetVectorFromInputs.c
 *\brief: recover velocity ug from inputs
 */

#include "./GetVectorFromInputs.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int name_enum;
	int type_enum;
	Vector*      ug=NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GetVectorFromInputsUsage);
	
	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchData(&parameters,PARAMETERS);
	FetchData(&name_enum,NAMEENUM);
	FetchData(&type_enum,TYPEENUM);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!core code:*/
	GetVectorFromInputsx(&ug,elements, nodes,vertices,loads, materials,parameters,name_enum,type_enum);

	/*write output datasets: */
	WriteData(UG,ug);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void GetVectorFromInputsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [ug] = %s(elements,nodes,vertices,loads, materials,parameters,name_enum,type_enum);\n",__FUNCT__);
	_printf_(true,"\n");
}
