function flag=ismumps()
%ISMUMPS - figure out if MUMPS package was compiled with ISSM
%
%   Usage:
%       flag=ismumps();


configfile=[issmtier() '/bin/config.h']; %should find it in the install target
if ~exist(configfile,'file'),
	error(['File ' configfile ' not found. ISSM has not been configured yet!']);
end

%go through the file, and recover the line we want
flag=2;
fid=fopen(configfile,'r');
if(fid==-1), error(['could not open file: ' configfile]); end

while(true),
	tline=fgets(fid);
	if ~ischar(tline), break, end
	if strncmp(tline,'/* #undef _HAVE_MUMPS_ */',25),
		flag=0;
		break;
	end
	if  strncmp(tline,'#define _HAVE_MUMPS_',20),
		flag=1;
		break;
	end
end
fclose(fid);
if flag==2,
	error('could not determine whether MUMPS was or was not compiled');
end
