E_AR5_NINT_oR.R GISS Model E  coupled version          larissa   10/08/2010

!! E_AR5_NINT_oR is with NetCDF output;  
               + WMUI_multiplier=2. (to adjust Planetary albedo close to 30%) 
                 (U00a=0.54; U00b=1.0)

E4F40oQ32: E4F40 coupled to 1x1.25deg 32-layer GISS ocean model
E4F40 = modelE as frozen in April 2010:
modelE1 (3.0) 2x2.5 hor. grid with 40 lyrs, top at .1 mb (+ 3 rad.lyrs)
atmospheric composition from year 1850
ocean: coupled to 1x1.25deg 32-layer GISS ocean model (Russell - Schmidt)
uses turbulence scheme (no dry conv), grav.wave drag
time steps: dynamics 3.75 min leap frog; physics 30 min.; radiation 2.5 hrs
filters: U,V in E-W and N-S direction (after every physics time step)
         U,V in E-W direction near poles (after every dynamics time step)
         sea level pressure (after every physics time step)

Preprocessor Options
!#define TRACERS_ON                  ! include tracers code
#define USE_ENT
#define NEW_IO
#define CHECK_OCEAN                 ! needed to compile aux/file CMPE002
End Preprocessor Options

Object modules:
     ! resolution-specific source codes
RES_stratF40                        ! horiz/vert resolution, 2x2.5, top at 0.1mb, 40 layers
ORES_1Qx1_L32                       ! ocean horiz res 2x2.5deg, 32 vert layers
OSTRAITS_1QX1_COM                   ! dynamic ocean modules
DIAG_RES_F                          ! diagnostics
FFT144 OFFT288E                     ! Fast Fourier Transform

    ! lat-lon grid specific source codes
GEOM_B                              ! model geometry
DIAG_ZONAL GCDIAGb                  ! grid-dependent code for lat-circle diags
DIAG_PRT POUT                       ! diagn/post-processing output
IO_DRV                              ! new i/o 

     ! GISS dynamics with gravity wave drag
ATMDYN MOMEN2ND                     ! atmospheric dynamics
QUS_DRV QUS3D                       ! advection of Q/tracers
STRATDYN STRAT_DIAG                 ! stratospheric dynamics (incl. gw drag)

#include "modelE4_source_files"
#include "dynamic_ocn_source_files"
OCN_Int_LATLON                      ! atm-ocn regrid routines

Components:
#include "E4_components_nc"    /* without "Ent" */
Ent

Component Options:
OPTS_Ent = ONLINE=YES PS_MODEL=FBB    /* needed for "Ent" only */
OPTS_giss_LSM = USE_ENT=YES           /* needed for "Ent" only */

Data input files:
#include "IC_144x90_input_files_AR5"
#include "dynamic_ocn_288x180_input_files_AR5"
TOPO=Z2HX2fromZ1QX1N.BS1            ! surface fractions and topography (1 cell Bering Strait)

RVR=RD_Fb.RVR.bin                   ! river direction file (frac. ocean)

#include "land144x90_input_files"
#include "rad_input_files"
#include "TAero2008_input_files"
#include "O3_2005_input_files"

MSU_wts=MSU.RSS.weights.data      ! MSU-diag
REG=REG2X2.5                      ! special regions-diag

Label and Namelist:  (next 2 lines)
E_AR5_NINT_oR (NetCDF output; 1 cell Bering Strait; 2x2.5x40, 1850 atm.;  1x1.25x32 ocean)


&&PARAMETERS
#include "dynamic_ocn_params"

#include "sdragF40_params"
#include "gwdragF40_params"

! cond_scheme=2   ! newer conductance scheme (N. Kiang) ! not used with Ent

! Increasing U00a decreases the high cloud cover; increasing U00b decreases net rad at TOA
U00a=0.54      ! above 850mb w/o MC region; tune this first to get 30-35% high clouds
U00b=1.00      ! below 850mb and MC regions; then tune this to get rad.balance

WMUI_multiplier = 2.

PTLISO=15.       ! press(mb) above which rad. assumes isothermal layers
H2ObyCH4=1.      ! activates strat.H2O generated by CH4
KSOLAR=2         ! 2: use long annual mean file ; 1: use short monthly file

#include "atmCompos_1850_params"
madaer=3         ! 3: updated aerosols          ; 1: default sulfates/aerosols

DTO=112.5
DTsrc=1800.      ! cannot be changed after a run has been started
DT=225.
! parameters that control the Shapiro filter
DT_XUfilter=225. ! Shapiro filter on U in E-W direction; usually same as DT
DT_XVfilter=225. ! Shapiro filter on V in E-W direction; usually same as DT
DT_YVfilter=0.   ! Shapiro filter on V in N-S direction
DT_YUfilter=0.   ! Shapiro filter on U in N-S direction

NIsurf=2         ! (surf.interaction NIsurf times per physics time step)
NRAD=5           ! radiation (every NRAD'th physics time step)

#include "diag_params"

Nssw=2           ! until diurnal diags are fixed, Nssw has to be even
Ndisk=480
&&END_PARAMETERS

 &INPUTZ
 YEARI=1900,MONTHI=12,DATEI=1,HOURI=0, ! pick IYEAR1=YEARI (default) or < YEARI
   YEARE=2001,MONTHE=12,DATEE=1,HOURE=0, KDIAG=13*0,
   ISTART=2,IRANDI=0, YEARE=1900,MONTHE=12,DATEE=1,HOURE=1,IWRITE=1,JWRITE=1,
 &END
