function varargout=updatearchive(varargin)
%updatearchive - test deck for ISSM nightly runs
%
%   Usage:
%      varargout=updatearchive(varargin);
%
%   Examples:
%      updatearchive;
%      updatearchive({'ice'});
%      updatearchive({'ice','cielo_serial'},{'absolute'});
%      md=updatearchive({'cielo_parallel'});
%
%   See also: RUNME

% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet with icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%check arguments
if (nargin>2 | nargout>1)
	help updatearchive
	error('updatearchive error message: bad usage');
end

%packages and misfits to be tested
if nargin==2,
	misfits=varargin{2};
else
	misfits={'absolute','relative','logarithmic'};
end
if nargin,
	packages=varargin{1};
else
	packages={'cielo_parallel','cielo_serial'};
end

%Initialize log message for nightly runs.
testname='PigControlMethodDragM2d_20';

%go through the solutions requested
for i=1:length(packages),
	package=packages{i};

	for j=1:length(misfits),
		misfit=misfits{j};

		%check package
		if ~(strcmpi(package,'cielo_parallel'));
			disp(['package: ' package  ' in test: ' testname  ' not supported yet']);
			continue
		end

		%initialize model
		md=model;
		md=mesh(md,'DomainOutline.exp',9000);
		md=geography(md,'Iceshelves.exp','Islands.exp');
		md=parameterize(md,'Pig.par');
		md=extrude(md,4,2);
		md=setelementstype(md,'pattyn','all');
		if strcmpi(misfit,'absolute'),
			md.fit(:)=0;
		elseif strcmpi(misfit,'relative'),
			md.fit(:)=1;
		elseif strcmpi(misfit,'logarithmic'),
			md.fit(:)=2;
		end

		%launch control method
		[md packagefinal]=testsgetpackage(md,package);
		if ~testscheckmisfit(misfit), continue; end
		md=solve(md,'analysis_type','control','package',packagefinal);

		%compute fields to be checked
		fields=testsgetfields(md.type,'control');

		%save new archive
		for k=1:length(fields),
			field=fields{k};
			eval(['Archive' package misfit '_field' num2str(k) '=md.results.' field  ';']);
		end
		eval(['save Archive' package misfit ' Archive' package misfit '_field*']);
	end
end
if nargout==1, 
	varargout{1}=md; 
end
