/*!\file IntInput.c
 * \brief: implementation of the IntInput object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*IntInput constructors and destructor*/
/*FUNCTION IntInput::IntInput(){{{1*/
IntInput::IntInput(){
	return;
}
/*}}}*/
/*FUNCTION IntInput::IntInput(double* values){{{1*/
IntInput::IntInput(int in_enum_type,IssmInt in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION IntInput::~IntInput(){{{1*/
IntInput::~IntInput(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntInput::DeepEcho{{{1*/
void IntInput::DeepEcho(void){

	printf("IntInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %i\n",(int)this->value);
}
/*}}}*/
/*FUNCTION IntInput::Id{{{1*/
int    IntInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntInput::MyRank{{{1*/
int    IntInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#ifdef _SERIAL_
/*FUNCTION IntInput::Marshall{{{1*/
void  IntInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of IntInput: */
	enum_value=IntInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall IntInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION IntInput::MarshallSize{{{1*/
int   IntInput::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION IntInput::Demarshall{{{1*/
void  IntInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION IntInput::ObjectEnum{{{1*/
int IntInput::ObjectEnum(void){

	return IntInputEnum;

}
/*}}}*/
/*FUNCTION IntInput::copy{{{1*/
Object* IntInput::copy() {
	
	return new IntInput(this->enum_type,this->value);

}
/*}}}*/

/*IntInput management*/
/*FUNCTION IntInput::Echo {{{1*/
void IntInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntInput::InstanceEnum{{{1*/
int IntInput::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION IntInput::SpawnTriaInput{{{1*/
Input* IntInput::SpawnTriaInput(int* indices){

	/*output*/
	IntInput* outinput=new IntInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;
}
/*}}}*/
/*FUNCTION IntInput::SpawnResult{{{1*/
ElementResult* IntInput::SpawnResult(int step, double time){
	
	_error_(" not supported yet!");

}
/*}}}*/

/*Object functions*/
/*FUNCTION IntInput::GetInputValue(bool* pvalue) {{{1*/
void IntInput::GetInputValue(bool* pvalue){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetInputValue(int* pvalue){{{1*/
void IntInput::GetInputValue(int* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION IntInput::GetInputValue(double* pvalue){{{1*/
void IntInput::GetInputValue(double* pvalue){
	_error_("IntInput cannot return a double in parallel");
}
/*}}}*/
/*FUNCTION IntInput::GetInputValue(double* pvalue,GaussTria* gauss){{{1*/
void IntInput::GetInputValue(double* pvalue,GaussTria* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetInputValue(double* pvalue,GaussPenta* gauss){{{1*/
void IntInput::GetInputValue(double* pvalue,GaussPenta* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss){{{1*/
void IntInput::GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss){{{1*/
void IntInput::GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss){_error_(" not supported yet!");}
/*}}}*/
/*FUNCTION IntInput::ChangeEnum{{{1*/
void IntInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION IntInput::SquareMin{{{1*/
void IntInput::SquareMin(double* psquaremin, bool process_units,Parameters* parameters){

	/*square min of an integer is the square of the integer itself: */
	*psquaremin=pow((double)value,2);
}
/*}}}*/
/*FUNCTION IntInput::Scale{{{1*/
void IntInput::Scale(double scale_factor){
	double dvalue=(double)value*scale_factor;
	value=(int)dvalue;
}
/*}}}*/
/*FUNCTION IntInput::AXPY{{{1*/
void IntInput::AXPY(Input* xinput,double scalar){

	double dvalue;
	IntInput*  xintinput=NULL;

	/*xinput is of the same type, so cast it: */
	xintinput=(IntInput*)xinput;

	/*Carry out the AXPY operation depending on type:*/
	switch(xinput->ObjectEnum()){

		case IntInputEnum:
			dvalue=(double)this->value+scalar*(double)xintinput->value;
			this->value=(int)dvalue;
			return;

		default:
			_error_("not implemented yet");
	}

}
/*}}}*/
/*FUNCTION IntInput::Constrain{{{1*/
void IntInput::Constrain(double cm_min, double cm_max, double cm_thresh){

	if(!isnan(cm_min)) if (this->value<cm_min)this->value=(int)cm_min;
	if(!isnan(cm_max)) if (this->value>cm_max)this->value=(int)cm_max;
	if(!isnan(cm_thresh)) if (this->value<cm_thresh)this->value=(int)cm_min;

}
/*}}}*/
/*FUNCTION IntInput::GetVectorFromInputs{{{1*/
void IntInput::GetVectorFromInputs(Vector* vector,int* doflist){

	_error_(" not supporte yet!");

}
/*}}}*/
/*FUNCTION IntInput::GetValuesPtr{{{1*/
void IntInput::GetValuesPtr(double** pvalues,int* pnum_values){

	_error_(" not supported yet!");

}
/*}}}*/
/*FUNCTION IntInput::Configure{{{1*/
void IntInput::Configure(Parameters* parameters){
	/*do nothing: */
}
/*}}}*/
