
#include <Python.h>
#define PY_ARRAY_UNIQUE_SYMBOL myname
#include "arrayobject.h"

void Write(PyObject* tuple, int index);

static PyObject* test_func(PyObject* self,PyObject* args){  //{{{
	
	/*inputs: */
	char* filename=NULL;
	double area;
	int   order;

	/*outputs: */
	npy_intp dim=10;
	PyObject* array=NULL;
	double* buffer=NULL;

	/*Recover inputs: */
	if (!PyArg_ParseTuple(args, "sdi", &filename,&area,&order)) return NULL;
	
	/*Build array: */
	buffer=(double*)calloc(dim,sizeof(double));
	array=PyArray_SimpleNewFromData(1,&dim,NPY_DOUBLE,buffer);

	
	/*return: */
	return Py_BuildValue("Os", array,filename);
	
}
//}}}
static PyObject* test2_func(PyObject* self,PyObject* args){  //{{{
	
	/*inputs: */
	PyObject* string=NULL;
	PyObject* string_bytes;
	const char* filename=NULL;

	PyObject* value;
	double area;

	PyObject* other;
	int   order;

	/*outputs: */
	npy_intp dim=10;
	PyObject* array=NULL;
	double* buffer=NULL;
	PyObject* tuple=NULL;

	
	if (!(string=PyTuple_GetItem(args, 0))) return NULL;
	PyUnicode_FSConverter(string,&string_bytes);
	filename=PyBytes_AS_STRING(string_bytes);
	
	
	if (!(value=PyTuple_GetItem(args, 1))) return NULL;
	area=PyFloat_AsDouble(value);
	
	if (!(other=PyTuple_GetItem(args, 2))) return NULL;
	order=(int)PyLong_AsLong(other);

	printf("%s %g %i\n",filename,area,order);



	tuple = PyTuple_New(2);
	if (!tuple) return NULL;
	
	/*Build array: */
	buffer=(double*)calloc(dim,sizeof(double));
	array=PyArray_SimpleNewFromData(1,&dim,NPY_DOUBLE,buffer);


	PyTuple_SetItem(tuple, 0, PyUnicode_FromString(filename));
	PyTuple_SetItem(tuple, 1, array);

	
	/*return: */
	return tuple;
	
}
//}}}
static PyObject* test3_func(PyObject* self,PyObject* args){  //{{{
	
	/*inputs: */
	PyObject* string=NULL;
	PyObject* string_bytes;
	const char* filename=NULL;

	PyObject* value;
	double area;

	PyObject* other;
	int   order;

	/*outputs: */
	PyObject* tuple=NULL;

	
	if (!(string=PyTuple_GetItem(args, 0))) return NULL;
	PyUnicode_FSConverter(string,&string_bytes);
	filename=PyBytes_AS_STRING(string_bytes);
	
	
	if (!(value=PyTuple_GetItem(args, 1))) return NULL;
	area=PyFloat_AsDouble(value);
	
	if (!(other=PyTuple_GetItem(args, 2))) return NULL;
	order=(int)PyLong_AsLong(other);

	printf("%s %g %i\n",filename,area,order);


	tuple = PyTuple_New(2);
	if (!tuple) return NULL;
	
	
	PyTuple_SetItem(tuple, 0, PyUnicode_FromString(filename));
	Write(tuple,1);

	
	/*return: */
	return tuple;
	
}
//}}}
/*Python wrapping: {{{*/
static PyMethodDef Test2_funcs[] = {
	{"test", (PyCFunction)test_func, METH_VARARGS, ""},
	{"test2", (PyCFunction)test2_func, METH_VARARGS, ""},
	{"test3", (PyCFunction)test3_func, METH_VARARGS, ""},
	{NULL,NULL,0,NULL}
};

static struct PyModuleDef Test2module= {
	PyModuleDef_HEAD_INIT,
	"Test2",   /* name of module */
	NULL, /* module documentation, may be NULL */
	-1,       /* size of per-interpreter state of the module,
				 or -1 if the module keeps state in global variables. */
	Test2_funcs
};

PyMODINIT_FUNC PyInit_Test2(void){

	import_array();
	return PyModule_Create(&Test2module);
}
/*}}}*/
