function marshall(md)
%MARSHALL - outputs a compatible binary file from @model md, for certain solution type.
%
%   The routine creates a compatible binary file from @model md
%   This binary file will be used for parallel runs in JPL-package
%
%   Usage:
%      marshall(md)

disp(['marshalling file ' md.miscellaneous.name '.bin']);

%open file for binary writing
fid=fopen([ md.miscellaneous.name '.bin'],'wb');
if fid==-1,
	error(['marshall error message: could not open ' [md.miscellaneous.name '.bin'],' file for binary writing']);
end

%Go through all model fields: check that it is a class and call checkconsistency
fields=properties('model');
for i=1:length(fields),
	field=fields{i};

	%Some properties do not need to be marshalled
	if ismember(field,{'results' 'radaroverlay' 'solver' 'cluster'  'flaim' 'private'}),
		continue;
	end

	%Check that current field is an object
	if ~isobject(md.(field))
		checkmessage(['field ''' char(field) ''' is not an object']);
	end

	%Marshall current object
	%disp(['marshalling ' field '...']);
	if verLessThan('matlab', '7.6')
		marshall(md.(field),fid);
	else
		md.(field).marshall(fid);
	end
end

%close file
st=fclose(fid);
if st==-1,
	error(['marshall error message: could not close file ' [md.miscellaneous.name '.bin']]);
end
