/*!\file Contour.h
 * \brief: header file for Contour object
 */

#ifndef _CONTOUR_H_
#define _CONTOUR_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../shared/Exceptions/exceptions.h"
#include "../toolkits/toolkits.h"
#include "../include/include.h"
/*}}}*/

class Contour: public Object{

	public: 

		int     id;
		int	  nods;  //number of vertices in the contour
		double* x;
		double* y;
		bool    closed; //is this contour closed?

		/*Contour constructors, destructors {{{1*/
		Contour();
		Contour(int id, int nods, double* x, double* y,bool closed);
		~Contour();
		/*}}}*/
		/*Object virtual functions{{{1*/
		void  Echo(void);
		void  DeepEcho(void);
		int   Id(void);
		int   MyRank(void);
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize(void);
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum(void);
		Object* copy(void);
		/*}}}*/


};

#endif  /* _CONTOUR_H_ */
