/*\file FetchData.cpp:
 * \brief: general I/O interface to fetch data in python
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../shared/shared.h"
#include "../../include/include.h"

#if defined(_HAVE_PYTHON_) && defined(_SERIAL_)
/*FUNCTION FetchData(char** pstring,char* string){{{1*/
void FetchData(char** pstring,char* string){

	/*Copy string into string: */
	char* outstring=NULL;

	outstring=(char*)xmalloc((strlen(string)+1)*sizeof(char));
	strcpy(outstring,string);

	*pstring=outstring;
}
/*FUNCTION FetchData(double* pscalar,double scale){{{1*/
void FetchData(double* pscalar,double scalar){

	/*simple copy: */
	*pscalar=scalar;
}
/*}}}*/
/*FUNCTION FetchData(int* pinteger,int integer){{{1*/
void FetchData(int* pinteger, int integer){

	/*simple copy: */
	*pinteger=integer;
}
/*}}}*/
/*FUNCTION FetchData(bool* pboolean,bool boolean){{{1*/
void FetchData(bool* pboolean,bool boolean){

	/*simple copy: */
	*pboolean=boolean;
	
}
/*}}}*/
#endif
