/*
	TriMesh.h
*/

#ifndef _TRIMESH_H
#define _TRIMESH_H


#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../c/include/globals.h"
#include "../../c/include/include.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/io/io.h"
#include "../../c/EnumDefinitions/EnumDefinitions.h"

#ifdef _HAVE_MATLAB_
/* serial input macros: */
#define DOMAINOUTLINE     (mxArray *)prhs[0]
#define AREA        (mxArray *)prhs[1]
#define ORDER     (mxArray *)prhs[2]

/* serial output macros: */
#define INDEX  (mxArray**)&plhs[0]
#define X  (mxArray**)&plhs[1]
#define Y   (mxArray**)&plhs[2]
#define SEGMENTS   (mxArray**)&plhs[3]
#define SEGMENTMARKERLIST (mxArray**)&plhs[4]

#endif

/* local prototypes: */
void TriMeshUsage(void);

#undef __FUNCT__ 
#define __FUNCT__  "TriMesh"

/* serial arg counts: */
#undef NLHS
#define NLHS  5
#undef NRHS
#define NRHS  3

#endif  /* _TRIMESH_H */
