#This installs the Android SDK (Software Development Kit)
#which is needed for the compilation of the Java project. 

step=3;

#Different steps here. 
#1: install sdk, ant and sdk tools
#2: install an emulator.
#3: test the emulator
#4: cleanup

present_dir=`pwd`;
default_droid="Android-4.0.3"

if [[ $step == "1" ]]; then

	#Cleanup the install
	rm -rf install-sdk install-ant

	# Install Android SDK and NDK.
	unzip -o android-sdk-r16-macosx.zip
	unzip -o apache-ant-1.8.2-bin.zip

	#Move to install
	mv android-sdk-macosx install-sdk
	mv apache-ant-1.8.2 install-ant

	#Post_install configuration: 
	#We need specific settings for specific platforms, for the SDK to 
	#function properly

	#For now, we need to install:  
	#android sdk platform tools  
	#and a specific android api: API 15
	#Note: API 15 corresponds to Android 4.0.3

	cd install-sdk/tools/ && source ./android update sdk -t platform-tools,android-15,android-14,system-image --no-ui

fi

if [[ $step == "2" ]]; then

	#Once this is done, we need to install an emulator. Location will default to ~/.android/avd, 
	#which we will move to $ISSM_TIER/externalpackages/android-emulators.  
	#For now, it's called: Android-4.0.3


	#Here we delete the Android-4.0.3 device if it already exists.
	cd $present_dir/install-sdk/tools

    if [ -e $ISSM_TIER/externalpackages/android-emulators/$default_droid ] 
    then
        echo "Deleting previously created device: $default_droid"
	    ./android delete avd -n $default_droid
    fi

	#Android will prompt the user to specify hardware emulation options. For now, default
	#default settings will suffice. Press 'enter' to take default settings or enter 'no'.

	./android create avd -f -n $default_droid -t 1 -p $ISSM_TIER/externalpackages/android-emulators/$default_droid --abi armeabi-v7a
fi

if [[ $step == "3" ]]; then
	#Here we will start up our default emulator to test that it is working properly.
    #Once the device has booted we will use the Android Debug Bridge tool to gain
    #a terminal in our device.

	cd $present_dir/install-sdk/tools
	./emulator -avd $default_droid &
    cd ../platform-tools
    ./adb wait-for-device shell

fi

if [[ $step == "4" ]]; then
	rm -rf install-sdk install-ant
fi
