#!/bin/bash

# Adapted from petsc 3.2. 
# Used Mercurial to get code
#       hg clone http://petsc.cs.iit.edu/petsc/petsc-dev
#       cd petsc-dev
#	     hg clone http://petsc.cs.iit.edu/petsc/BuildSystem config/BuildSystem

# To update (via Mercurial):
#      cd petsc-dev
#      hg pull -u
#      cd config/BuildSystem
#      hg pull -u


# configure script
# Note: using metis from externalpackages did not work...
# for now downloading new metis
#   -then rename metis in externalpackages to metis2


cd src
./config/configure.py \
	--prefix="$ISSM_TIER/externalpackages/petsc-dev/install" \
	--with-mpi-dir=$ISSM_TIER/externalpackages/mpich2/install \
	--with-clanguage=C++ \
	--PETSC_ARCH=linux-gnu-amd64 \
	--PETSC_DIR="$ISSM_TIER/externalpackages/petsc-dev/src" \
	--with-debugging=0 \
	--with-shared-libraries=0 \
	--download-metis=yes \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-f-blas-lapack=yes \
	--download-plapack=yes \
	--download-parmetis=yes \
	--with-pic=1

#Compile petsc and install it
make
make install
