#include <stdio.h>
/* #include "tools.h" */
#include "search.h"
#include "tex.h"
/*
   This is a simple program to translate mostly ASCII text code from 
   a latexinfo file into another format.  Different formats can be
   generated by providing different versions of the file tex2....c
   For example, 
       tex2win generates Windows help output.
       tex2html generates HTML (WWW) output
   
 */

int DoGaudy = 0;       /* If true, generate more colorful output (
			  unimplemented) */

/* 
   I'd like to push a token in every routine, but the PC version seems to
   run out of stack space (very, very tiny stacks!) 
 */

static FILE *ferr = stderr;

static int InDocument = 0;

void TXStartDoc( flag )
int flag;
{
InDocument = flag;
}

static int IsPreformatted = 0;
void TXpreformated( fout, flag )
FILE *fout;
int flag;
{
IsPreformatted = flag;
}

/*
    TeX processing:
    We need to manage things like \section{name}, \begin{tex}, \c (comment)

    Multiple blank lines must generate a \par in the rtf file.
    More specifically, a completely blank line must be changed into a par.
 */  
    
/*
    This file contains the actions for processing a subset of LaTeXinfo
    files
 */

int TeXoutNewline( fout )
FILE *fout;
{
/* Note that we change a newline into space-newline; TeX takes newline as a
   space; RTF does not */
TeXoutstr( fout, " \n" );
}

/* Handle \\ in TeX file */
void TXbw2( e )
TeXEntry *e;
{
/* Usually a par */
if (!InDocument) return;
TeXoutcmd( fpout, "\\par " );
}
/* I use \bw in LaTeXinfo to generate a \ */
void TXbw( e )
TeXEntry *e;
{
if (!InDocument) return;
TeXoutstr( fpout, "\\\\" );
}
void TXoutbullet( e )
TeXEntry *e;
{
if (!InDocument) return;
TeXoutcmd( fpout, "\\f1\\'b7" );
}

void TXbf( e )
TeXEntry *e;
{
/* output start of BoldFace */
if (!InDocument) return;
TeXoutcmd( fpout, "\\b " );
}

void TXem( e )
TeXEntry *e;
{
/* output start of Emphasis (italics) */
if (!InDocument) return;
TeXoutcmd( fpout, "\\i " );
}

void TXsf( e )
TeXEntry *e;
{
if (!InDocument) return;
/* Remain in Roman for now */
}

void TXrm( e )
TeXEntry *e;
{
if (!InDocument) return;
/* Remain in Roman for now */
}

void TXbgroup( e )
TeXEntry *e;
{
if (!InDocument) return;
TeXoutcmd( fpout, "{" );
}

void TXegroup( e )
TeXEntry *e;
{
if (!InDocument) return;
TeXoutcmd( fpout, "}" );
}

void TXfont_tt( e )
TeXEntry *e;
{
/* output start of TT (Courier) in default face*/
if (!InDocument) return;
TeXoutcmd( fpout, "\\f5 " );
}

void TXfont_ss( e )
TeXEntry *e;
{
/* output start of Sans Serif in default face*/
if (!InDocument) return;
TeXoutcmd( fpout, "\\f4 " );
}

void TXtt( e )
TeXEntry *e;
{
/* output start of TT (Courier) in default face*/
if (!InDocument) return;
TeXoutcmd( fpout, "\\f5\\plain " );
}

void TXbitmap( e )
TeXEntry *e;
{
/* Process a bitmap reference */	
}

void TXWritePar( fp )
FILE *fp;
{
if (!InDocument) return;
TeXoutcmd( fp, "\\par\n" );
}

void TXimage( e, fname )
TeXEntry *e;
char     *fname;
{
}

void TXInlineImage( e, fname )
TeXEntry *e;
char     *fname;
{
}

void TXAnchoredImage( e, anchorname, fname )
TeXEntry *e;
char     *anchorname, *fname;
{
}

void TXAnchoredInlineImage( e, anchorname, fname )
TeXEntry *e;
char     *anchorname, *fname;
{
}

void TXmovie( e, movie, icon, text )
TeXEntry *e;
char     *movie, *icon, *text;
{
}

void TXbbrace( e )
TeXEntry *e;
{
if (!InDocument) return;	
TeXoutcmd( fpout, "\\{" );
}

void TXebrace( e )
TeXEntry *e;
{
if (!InDocument) return;	
TeXoutcmd( fpout, "\\}" );
}

void TXmath( e )
TeXEntry *e;
{
if (!InDocument) return;	
TeXoutcmd( fpout, "\\line{\\i " );
}
void TXmathend( e )
TeXEntry *e;
{
if (!InDocument) return;	
TeXoutcmd( fpout, "}\\line" );
}
void TXinlinemath( e )
TeXEntry *e;
{
if (!InDocument) return;	
TeXoutcmd( fpout, "{\\i " );
}
void TXinlinemathend( e )
TeXEntry *e;
{
if (!InDocument) return;	
TeXoutcmd( fpout, "}" );
}

int TXWriteStartNewLine( fout )
FILE *fout;
{
WriteStartNewLine( fout );
}

int TXWriteStartItem( fout )
FILE *fout;
{
WriteStartNewLine( fout );
}

void TXmaketitle( e, TitleString, AuthorString )
TeXEntry *e;
char *TitleString, *AuthorString;
{
WriteLargeFont( fpout );	
WriteCenter( fpout );
WriteString( fpout, TitleString );
WritePar( fpout );
WriteString( fpout, AuthorString );
WritePar( fpout );
WriteDefaultFont( fpout );
WritePlain( fpout );	
}

/* Itemize environement */
void TXbitemize( e )
TeXEntry *e;
{
}	
void TXeitemize( e )
TeXEntry *e;
{
}	

/* Enumerate environment */
void TXbenumerate( e )
TeXEntry *e;
{
}
void TXeenumerate( e )
TeXEntry *e;
{
}
void TXbdescription( e )
TeXEntry *e;
{
}
void TXedescription( e )
TeXEntry *e;
{
}
/* Menus */	
void TXbmenu( e )
TeXEntry *e;
{
}
void TXemenu( e )
TeXEntry *e;
{
}

/* Description Item */	
void TXbdesItem( e )
TeXEntry *e;
{
}

void TXedesItem( e )
TeXEntry *e;
{
}	

void TXWriteHyperLink( fout, token, url, urltype )
FILE *fout;
char *token, *url;
int  urltype;
{
fprintf( fout, "ref %s", token );	
}	

