/*! \file Beam.h 
 *  \brief: header file for beam object
 */

#ifndef _BEAM_H_
#define _BEAM_H_


#include "./Element.h"
#include "./Node.h"
#include "./Matice.h"
#include "./Matpar.h"
#include "./ParameterInputs.h"

class Beam: public Element{

	private: 

		/*ids:*/
		int id;

		/*nodes: */
		int   node_ids[2]; //node ids
		Node* nodes[2]; //node pointers
		int   node_offsets[2]; //node offsets in nodes dataset

		/*materials: */
		int   mid;
		Matice* matice; 
		int   matice_offset;
		
		int mparid;
		Matpar* matpar; 
		int   matpar_offset;
					
		double h[2];
		double s[2];
		double b[2];
		double k[2];

		bool onbed;

	public:

		Beam();
		Beam(int beam_id, int beam_mid, int beam_mparid, int beam_g[2], double beam_h[2], double beam_s[2],double beam_b[2],double beam_k[2],bool beam_onbed);
		~Beam();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  Configure(void* loads,void* nodes,void* materials);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  CreatePVectorDiagnosticHutter(Vec pg,void* inputs,int analysis_type,int sub_analysis_type);
		void* GetMatPar();

		Object* copy();
		void  NodeConfiguration(int* beam_node_ids,Node* beam_nodes[2],int* beam_node_offsets);
		void  MaticeConfiguration(Matice* matice,int matice_offset);
		void  MatparConfiguration(Matpar* matpar,int matpar_offset);
		void  ComputePressure(Vec p_g);
		void  GetNodes(void** vpnodes);
		
		/*not implemented: */
		int   GetShelf();
		int   GetOnBed();
		void  GetBedList(double*);
		void  GetThicknessList(double* thickness_list);
		void  Du(_p_Vec*,void*, int,int);
		void  Gradj(_p_Vec*, void*, int, int,char*);
		void  GradjDrag(_p_Vec*, void*, int,int );
		void  GradjB(_p_Vec*, void*, int,int );
		double Misfit(void*,int,int );
		void  GetNodalFunctions(double* l1l2, double gauss_coord);
		void  GetParameterValue(double* pvalue, double* value_list,double gauss_coord);
		void  GetJacobianDeterminant(double* pJdet,double* z_list, double gauss_coord);

};
#endif  /* _BEAM_H */
