/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"

#undef __FUNCT__ 
#define __FUNCT__ "Gradjx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void Gradjx( Vec* pgrad_g, int numberofnodes, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials, 
			ParameterInputs* inputs,int analysis_type,int sub_analysis_type,char* control_type){

	/*output: */
	Vec grad_g=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);

	/*Allocate grad_g: */
	grad_g=NewVec(numberofnodes);

	/*Compute gradients: */
	elements->Gradj(grad_g,inputs,analysis_type,sub_analysis_type,control_type);

	/*Assemble vector: */
	VecAssemblyBegin(grad_g);
	VecAssemblyEnd(grad_g);

	/*Assign output pointers: */
	*pgrad_g=grad_g;
}
