/*
 * TriMesh: mesh a domain using an .exp file
 */

#include "./TriMesh.h"

void mexFunction(	int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[] ){

	/* input: */
	char*  domainname=NULL;
	double area;
	bool   order;

	/*intermediary: */
	DataSet* domain=NULL;

	/* output: */
	Matrix* index=NULL;
	Vector* x=NULL;
	Vector* y=NULL;
	Matrix* segments=NULL;
	Vector* segmentmarkerlist=NULL;

	/*Boot module: */
	MODULEBOOT();
printf("ok1\n");

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&TriMeshUsage);
printf("ok2\n");

	/*Fetch data needed for meshing: */

	FetchMatlabData(&domainname,DOMAINOUTLINE);
	FetchMatlabData(&area,AREA);
	FetchMatlabData(&order,ORDER);
printf("ok3 %g %s\n",area,domainname);

	/*Read domain outline: */
	domain=DomainOutlineRead(domainname,false);
printf("ok4\n");

	/*call x core: */
	TriMeshx(&index,&x,&y,&segments,&segmentmarkerlist,domain,area,order);
printf("ok5\n");

	/*write outputs: */
	/*WriteMatlabData(INDEX,index);
	WriteMatlabData(X,x);
	WriteMatlabData(Y,y);
	WriteMatlabData(SEGMENTS,segments);
	WriteMatlabData(SEGMENTMARKERLIST,segmentmarkerlist);*/

	/*free ressources: */
	delete domain;
	/*
	xdelete(&index);
	xdelete(&x);
	xdelete(&y);
	xdelete(&segments);
	xdelete(&segmentmarkerlist);*/

	/*end module: */
	MODULEEND();
}

void TriMeshUsage(void)
{
	printf("\n");
	printf("   usage: [index,x,y,segments,segmentmarkers]=TriMesh(domainoutlinefilename,area,ordered) \n");
	printf("      where: index,x,y defines a triangulation, segments is an array made \n");
	printf("      of exterior segments to the mesh domain outline, segmentmarkers is an array flagging each segment, \n");
	printf("      outlinefilename an Argus domain outline file, \n");
	printf("      area is the maximum area desired for any element of the resulting mesh, \n");
	printf("      and ordered is a bool that determines whether segments are output in the \n");
	printf("      order they are made by Triangle (ie none), or ordered counter clockwise around the domain outline.\n");
	printf("\n");
}
