%SOLVER class definition
%
%   Usage:
%      obj=solver();

classdef solver < dynamicprops
    properties (SetAccess=public) 
		 NoneAnalysis
		 %The other properties are dynamic
	 end
	 methods
		 function obj = solver(varargin) % {{{
			 switch nargin
				 case 0
					 obj=setdefaultparameters(obj);
				 otherwise
					 error('constructor not supported');
				 end
			 end % }}}
		 function obj = setdefaultparameters(obj) % {{{

			 %MUMPS is the default solver
			 if ismumps,
				 obj.NoneAnalysis=mumpsoptions;
			 else
				 obj.NoneAnalysis=iluasmoptions;
			 end

		 end % }}}
		 function obj = addoptions(obj,analysis,solveroptions) % {{{1

			 %Convert analysis from enum to string
			 analysis=EnumToString(analysis);

			 %Create dynamic property if property does not exist yet
			 if ~ismember(analysis,properties(obj)),
				 obj.addprop(analysis);
			 end

			 %Add solver options to analysis
			 obj.(analysis) = solveroptions;
		 end
		 %}}}
		 function checkconsistency(obj,md,solution,analyses) % {{{
			 %Nothing checked
		 end % }}}
		 function PetscFile(solver,filename) % {{{
		 %PETSCFILE - build petsc file
		 %
		 %   Build a Petsc compatible options file, from the solver model field  + return options string
		 %
		 %   Usage:     PetscFile(solver,filename);

			 %open file for writing
			 fid=fopen(filename,'w');
			 if fid==-1,
				 error(['PetscFile error: could not open ' filename ' for writing']);
			 end

			 %write header
			 fprintf(fid,'%s%s%s\n','%Petsc options file: ',filename,' written from Matlab solver array');

			 %start writing options
			 analyses=properties(solver);
			 for i=1:numel(analyses),
				 analysis=analyses{i};
				 options=solver.(analysis);

				 %first write analysis:
				 fprintf(fid,'\n+%s\n',analysis); %append a + to recognize it's an analysis enum

				 %now, write options
				 for j=1:size(options,2),
					 option=options{j};
					 if isempty(option),
						 %do nothing
					 elseif length(option)==1,
						 %this option has only one argument
						 fprintf(fid,'-%s\n',option{1});
					 elseif length(option)==2,
						 %option with value. value can be string or scalar
						 if isscalar(option{2}),
							 fprintf(fid,'-%s %g\n',option{1},option{2});
						 elseif ischar(option{2}),
							 fprintf(fid,'-%s %s\n',option{1},option{2});
						 else
							 error(['PetscFile error: option #' num2str(j) ' is not well formatted']);
						 end
					 else 
						 error(['PetscFile error: option #' num2str(j) ' is not well formatted']);
					 end
				 end
			 end

			 fclose(fid);
		 end %}}}
	 end
 end
