%DEBUG class definition
%
%   Usage:
%      debug=debug();

classdef debug
	properties (SetAccess=public) 
		valgrind=false;
		gprof   = false;
	end
	methods
		function obj = debug(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
				end
			end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   debug parameters:'));

			fielddisplay(obj,'valgrind','use Valgrind to debug (0 or 1)');
			fielddisplay(obj,'gprof','use gnu-profiler to find out where the time is spent');

		end % }}}
	end
end
