/* \file toolkits.h
 * \brief: this API allows use of external packages, provides patches, etc ...
 */

#ifndef _TOOLKITS_H_
#define _TOOLKITS_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _HAVE_PETSC_
#include "./petsc/petscincludes.h"
#endif

#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
#include "./matlab/matlabincludes.h"
#endif

#if defined(_HAVE_PYTHON_) && defined(_SERIAL_)
#include "./python/pythonincludes.h"
#endif

#include "./mpi/mpiincludes.h"
#include "./metis/metisincludes.h"
#include "./triangle/triangleincludes.h"
#include "./double/double.h"
#include "./toolkitsenums.h"
#include "./issm/issmtoolkit.h"

#endif
