/*!\file DoubleMatParam.c
 * \brief: implementation of the DoubleMatParam object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*DoubleMatParam constructors and destructor*/
/*FUNCTION DoubleMatParam::DoubleMatParam(){{{1*/
DoubleMatParam::DoubleMatParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleMatParam::DoubleMatParam(int enum_type,IssmDoubleMat value){{{1*/
DoubleMatParam::DoubleMatParam(int in_enum_type,double* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=(double*)xmalloc(M*N*sizeof(double));
	memcpy(value,in_value,M*N*sizeof(double));
}
/*}}}*/
/*FUNCTION DoubleMatParam::~DoubleMatParam(){{{1*/
DoubleMatParam::~DoubleMatParam(){
	xfree((void**)&value);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleMatParam::Echo {{{1*/
void DoubleMatParam::Echo(void){

	printf("DoubleMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);

}
/*}}}*/
/*FUNCTION DoubleMatParam::DeepEcho{{{1*/
void DoubleMatParam::DeepEcho(void){

	int i,j;
	
	printf("DoubleMatParam:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   matrix size: %ix%i\n",this->M,this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			printf("%i %i %g\n",i,j,*(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION DoubleMatParam::Id{{{1*/
int    DoubleMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleMatParam::MyRank{{{1*/
int    DoubleMatParam::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
/*FUNCTION DoubleMatParam::Marshall{{{1*/
void  DoubleMatParam::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleMatParam: */
	enum_value=DoubleMatParamEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleMatParam data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&M,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(marshalled_dataset,&N,sizeof(N));marshalled_dataset+=sizeof(N);
	memcpy(marshalled_dataset,value,M*N*sizeof(double));marshalled_dataset+=M*N*sizeof(double);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleMatParam::MarshallSize{{{1*/
int   DoubleMatParam::MarshallSize(){
	
	return sizeof(M)
		+sizeof(N)
		+M*N*sizeof(double)
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleMatParam::Demarshall{{{1*/
void  DoubleMatParam::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*data: */
	memcpy(&M,marshalled_dataset,sizeof(M));marshalled_dataset+=sizeof(M);
	memcpy(&N,marshalled_dataset,sizeof(N));marshalled_dataset+=sizeof(N);
	value=(double*)xmalloc(M*N*sizeof(double));
	memcpy(value,marshalled_dataset,M*N*sizeof(double));marshalled_dataset+=M*N*sizeof(double);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
#endif
/*FUNCTION DoubleMatParam::ObjectEnum{{{1*/
int DoubleMatParam::ObjectEnum(void){

	return DoubleMatParamEnum;

}
/*}}}*/
/*FUNCTION DoubleMatParam::copy{{{1*/
Object* DoubleMatParam::copy() {
	
	return new DoubleMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/

/*DoubleMatParam virtual functions definitions: */
/*FUNCTION DoubleMatParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){{{1*/
void  DoubleMatParam::GetParameterValue(double** pdoublearray,int* pM,int* pN){
	double* output=NULL;

	output=(double*)xmalloc((int)(M*N*sizeof(double)));
	memcpy(output,value,M*N*sizeof(double));

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pdoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){{{1*/
void  DoubleMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){
#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
	int* output=NULL;
	int  i;

	output=(int*)xmalloc((int)(M*N*sizeof(int)));
	for(i=0;i<M*N;i++) output[i]=(int)value[i];

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pintarray=output;
#else
	_error_("DoubleMat of enum %i (%s) cannot return an array of int",enum_type,EnumToStringx(enum_type));
#endif
}
/*}}}*/
/*FUNCTION DoubleMatParam::GetParameterName{{{1*/
void DoubleMatParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleMatParam::SetMatlabField{{{1*/
#if defined(_HAVE_MATLAB_) && defined(_SERIAL_)
void  DoubleMatParam::SetMatlabField(mxArray* dataref){

	mxArray* pfield=NULL;
	mxArray* pfield2=NULL;
	double* doublemat=NULL;
	char* name=NULL;
	
	this->GetParameterName(&name);
	this->GetParameterValue(&doublemat,NULL,NULL);
				
	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,N);
	mxSetN(pfield,M);
	mxSetPr(pfield,doublemat);
	
	//transpose the matrix, written directly to matlab! from C to matlab.
	mexCallMATLAB(1,&pfield2, 1, &pfield, "transpose");
	mxSetField( dataref, 0, name,pfield2);
}
#endif
/*}}}*/
/*FUNCTION DoubleMatParam::SetValue{{{1*/
void  DoubleMatParam::SetValue(double* doublearray,int in_M,int in_N){

	/*avoid leak: */
	xfree((void**)&this->value);

	this->value=(double*)xmalloc(in_M*in_N*sizeof(double));
	memcpy(this->value,doublearray,in_M*in_N*sizeof(double));

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
/*FUNCTION DoubleMatParam::UnitConversion{{{1*/
void  DoubleMatParam::UnitConversion(int direction_enum){
	::UnitConversion(this->value,this->M*this->N,direction_enum,this->enum_type);
}
/*}}}*/
		
/*diverse: */
/*FUNCTION DoubleMatParam::GetPointer{{{1*/
double* DoubleMatParam::GetPointer(void){
	return this->value;
}
/*}}}*/
