/*Copyright 2006  Phil Austin (http:www.eos.ubc.ca/personal/paustin)
  Distributed under the Boost Software License, Version 1.0. (See
  accompanying file LICENSE_1_0.txt or copy at
http:www.boost.org/LICENSE_1_0.txt)
*/

#define PY_ARRAY_UNIQUE_SYMBOL PyArrayHandle
#include "num_util.h"
#include <iostream>

namespace { const char* rcsid = "$Id: simpletest.cpp,v 1.4 2006/07/05 22:55:16 phil Exp $"; }

//send a dictionary with two arrays back to python
boost::python::dict testToPython(void){
	double ia[6] = {1,2,3,4,5,6};
	int ib[3] = {88,99,100};
	//construct two numpy arrays
	boost::python::numeric::array pyDoubles=num_util::makeNum(ia,6);
	boost::python::numeric::array pyInts=num_util::makeNum(ib,3);
	//pack them in a dictionary and return to python
	boost::python::dict retvals;
	retvals["myDoubles"]=pyDoubles;
	retvals["myInts"]=pyInts;
	return retvals;
}

//get an array from python
void testFromPython(boost::python::numeric::array inValue){
	num_util::check_type(inValue, PyArray_DOUBLE);
	num_util::check_rank(inValue, 2);
	double* dataPtr = (double*) num_util::data(inValue);
	int theSize= num_util::size(inValue);
	std::cout << std::endl << "data values on c++ side: " << std::endl;
	for(int i=0;i < theSize;++i){
		std::cout << *(dataPtr + i) << std::endl;
	}
}  

BOOST_PYTHON_MODULE(simple_ext)
{ 
	import_array();
	boost::python::numeric::array::set_module_and_type("numpy", "ArrayType");
	//global doc string
	boost::python::scope().attr("RCSID") = rcsid;
	std::string str1;
	str1="docstring for module\n";
	boost::python::scope().attr("__doc__") = str1.c_str();
	str1 = "Doc string for testToPython\n";
	def("testToPython", testToPython,str1.c_str());
	str1 = "Doc string for testFromPython\n";
	def("testFromPython", testFromPython,str1.c_str());
}

