/*\file Misfit.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./Misfit.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	double*  u_g=NULL;
	ParameterInputs* inputs=NULL;
	char*             analysis_type_string=NULL;
	int               analysis_type;
	char*             sub_analysis_type_string=NULL;
	int               sub_analysis_type;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MisfitUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTS,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODES,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADS,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALS,"DataSet",NULL);
	FetchData((void**)&u_g,NULL,NULL,UG,"Vector","Vec");
	FetchData((void**)&analysis_type_string,NULL,NULL,ANALYSIS,"String",NULL);
	analysis_type=AnalysisTypeAsEnum(analysis_type_string);
	FetchData((void**)&sub_analysis_type_string,NULL,NULL,SUBANALYSIS,"String",NULL);
	sub_analysis_type=AnalysisTypeAsEnum(sub_analysis_type_string);

	/*Fetch inputs: */
	inputs=new ParameterInputs;
	inputs->Init(INPUTS);

	/*!Call core code: */
	Misfitx(&J, elements,nodes,loads,materials,u_g,inputs,analysis_type,sub_analysis_type);

	/*write output : */
	WriteData(MISFIT,&J,0,0,"Scalar",NULL);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	xfree((void**)&u_g);
	delete inputs;
	xfree((void**)&analysis_type_string);
	xfree((void**)&sub_analysis_type_string);

	/*end module: */
	MODULEEND();
}

void MisfitUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [J] = %s(elements, nodes,loads, materials, parameters, u_g,inputs);\n",__FUNCT__);
	_printf_("\n");
}
