/*! \file Penta.h 
 *  \brief: header file for penta object
 */

#ifndef _PENTA_H
#define _PENTA_H

#include "./Object.h"
#include "./Element.h"
#include "./Matpar.h"
#include "./Matice.h"
#include "./Node.h"
#include "./Tria.h"
#include "./ParameterInputs.h"

class Penta: public Element{

	private: 
		int id;
		
		/*nodes: */
		int   node_ids[6]; //node ids
		Node* nodes[6]; //node pointers
		int   node_offsets[6]; //node offsets in nodes dataset

		/*materials: */
		int   mid;
		Matice* matice; 
		int   matice_offset;
		
		int mparid;
		Matpar* matpar; 
		int   matpar_offset;
	

		double h[6];
		double s[6];
		double b[6];
		double k[6];
		double melting[6];
		double accumulation[6];
		int    friction_type;
		double p;
		double q;
		int    shelf;
		int    onbed;
		int    onsurface;
		bool    onwater;
		double meanvel;/*!scaling ratio for velocities*/
		double epsvel; /*!minimum velocity to avoid infinite velocity ratios*/
		int    collapse;
		double geothermalflux[6];
		int    artdiff;
		int    thermal_steadystate;
		double viscosity_overshoot;
		double stokesreconditioning;
	
	public:

		Penta();
		Penta( int id, int mid, int mparid, int node_ids[6], double h[6], double s[6], double b[6], double k[6], int    friction_type, 
				double p, double q, int    shelf, int    onbed, int    onsurface, double meanvel,double epsvel, 
				int    collapse, double melting[6], double accumulation[6], double geothermalflux[6], 
				int    artdiff, int    thermal_steadystate,double viscosity_overshoot,double stokesreconditioning,bool onwater);
		~Penta();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  Configure(void* loads,void* nodes,void* materials);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticHoriz( Mat Kgg, void* inputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticVert( Mat Kgg, void* inputs, int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void* GetMatPar();
		int   GetShelf();
		void  GetNodes(void** nodes);
		int   GetOnBed();
		void  Du(Vec du_g,double* u_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,double* u_g,double* lambda_g,void* inputs,int analysis_type,int sub_analysis_type,char* control_type);
		void  GradjDrag(Vec grad_g,double* u_g,double* lambda_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  GradjB(Vec grad_g,double* u_g,double* lambda_g,void* inputs,int analysis_type,int sub_analysis_type);
		double Misfit(double* u_g,void* inputs,int analysis_type,int sub_analysis_type);
		
		void          GetThicknessList(double* thickness_list);
		void          GetBedList(double* bed_list);
		Object* copy();
		void*  SpawnTria(int g0, int g1, int g2);

		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_l1l2l3l4);
		void  GetB(double* pB, double* xyz_list, double* gauss_l1l2l3l4);
		void  GetBPrime(double* B, double* xyz_list, double* gauss_l1l2l3l4);
		void  GetB_vert(double* B, double* xyz_list, double* gauss_l1l2l3l4);
		void  GetBPrime_vert(double* B, double* xyz_list, double* gauss_l1l2l3l4);
		void  GetJacobianDeterminant(double*  Jdet, double* xyz_list,double* gauss_l1l2l3l4);
		void  GetNodalFunctionsDerivativesBasic(double* dh1dh2dh3dh4dh5dh6_basic,double* xyz_list, double* gauss_l1l2l3l4);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_l1l2l3l4);
		void  GetNodalFunctionsDerivativesParams(double* dl1dl2dl3dl4dl5dl6,double* gauss_l1l2l3l4);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_l1l2l3l4);
		void  CreatePVectorDiagnosticHoriz( Vec pg, void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticVert( Vec pg, void* inputs,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pvalue, double* v_list,double* gauss_l1l2l3l4);
		void  GetParameterDerivativeValue(double* p, double* p_list,double* xyz_list, double* gauss_l1l2l3l4);
		void  GetNodalFunctions(double* l1l2l3l4l5l6, double* gauss_l1l2l3l4);
		void  FieldExtrude(Vec field,double* field_serial,char* field_name, int iscollapsed);
		void  ComputePressure(Vec p_g);
		void  CreateKMatrixSlopeCompute(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorSlopeCompute( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);

		void  CreateKMatrixDiagnosticStokes( Mat Kgg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticStokes( Vec pg, void* vinputs,int analysis_type,int sub_analysis_type);
		void  ReduceMatrixStokes(double* Ke_reduced, double* Ke_temp);
		void  GetMatrixInvert(double*  Ke_invert, double* Ke);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GetStrainRateStokes(double* epsilon, double* velocity, double* xyz_list, double* gauss_coord);
		void  GetBStokes(double* B, double* xyz_list, double* gauss_coord);
		void  GetBprimeStokes(double* B_prime, double* xyz_list, double* gauss_coord);
		void  GetLStokes(double* LStokes, double* gauss_coord_tria);
		void  GetLprimeStokes(double* LprimeStokes, double* xyz_list, double* gauss_coord_tria, double* gauss_coord);
		void  GetNodalFunctionsDerivativesBasicStokes(double* dh1dh7_basic,double* xyz_list, double* gauss_coord);
		void  GetNodalFunctionsDerivativesParamsStokes(double* dl1dl7,double* gauss_coord);
		void  ReduceVectorStokes(double* Pe_reduced, double* Ke_temp, double* Pe_temp);
		void  GetNodalFunctionsStokes(double* l1l7, double* gauss_coord);
		void  CreateKMatrixThermal(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  GetB_conduct(double* B_conduct, double* xyz_list, double* gauss_coord);
		void  GetB_advec(double* B_advec, double* xyz_list, double* gauss_coord);
		void  GetBprime_advec(double* Bprime_advec, double* xyz_list, double* gauss_coord);
		void  CreateKMatrixMelting(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermal( Vec pg, void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorMelting( Vec pg, void* vinputs,int analysis_type,int sub_analysis_type);
		void  GetPhi(double* phi, double*  epsilon, double viscosity);


};
#endif  /* _PENTA_H */
	

