/*!\file Dux
 * \brief: diff between observed and modeled velocity
 */

#include "./Dux.h"

#undef __FUNCT__ 
#define __FUNCT__ "Dux"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void Dux( Vec* pdu_g, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials, 
		double* u_g,ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	int i;
	int gsize;
	int found;

	/*output: */
	Vec du_g=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);

	/*Get size of matrix: */
	gsize=nodes->NumberOfDofs();

	/*Allocate du_g: */
	du_g=NewVec(gsize);

	/*Compute velocity difference: */
	elements->Du(du_g, u_g,inputs,analysis_type,sub_analysis_type);

	/*Assemble vector: */
	VecAssemblyBegin(du_g);
	VecAssemblyEnd(du_g);

	/*Assign output pointers: */
	*pdu_g=du_g;
	
}
