/*!\file:  SeqVec.h
 * \brief wrapper to our SeqVec object, which is just a wrapper to a double* 
 */ 

#ifndef _SEQVEC_H_
#define _SEQVEC_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkitsenums.h"

#ifdef _HAVE_MATLAB_
#include "mex.h"
#endif

/*}}}*/

class SeqVec{

	public:
	
		double* vector;
		int M;

		/*SeqVec constructors, destructors {{{1*/
		SeqVec();
		SeqVec(int M,bool fromlocalsize=false);
		SeqVec(double* buffer, int M);
		~SeqVec();
		/*}}}*/
		/*SeqVec specific routines {{{1*/
		void Echo(void);
		#ifdef _HAVE_MATLAB_
		mxArray* ToMatlabVector(void);
		#endif
		void Assemble(void);
		void SetValues(int ssize, int* list, double* values, InsMode mode);
		void SetValue(int dof, double value, InsMode  mode);
		void GetValue(double* pvalue, int dof);
		void GetSize(int* pM);
		void GetLocalSize(int* pM);
		SeqVec* Duplicate(void);
		void Set(double value);
		void AXPY(SeqVec* X, double a);
		void AYPX(SeqVec* X, double a);
		double* ToMPISerial(void);
		void Copy(SeqVec* to);
		double Norm(NormMode norm_type);
		void Scale(double scale_factor);
		void PointwiseDivide(SeqVec* x,SeqVec* y);
		double Dot(SeqVec* vector);
		/*}}}*/
};


/*API :*/
#ifdef _HAVE_MATLAB_
SeqVec*  MatlabVectorToSeqVec(const mxArray* dataref);
#endif

#endif //#ifndef _SEQVEC_H_
