/*!\file:  SeqMat.h
 * \brief wrapper to SeqMat objects, which are just wrappers to a simple double* buffer.
 */ 

#ifndef _SEQMAT_H_
#define _SEQMAT_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkitsenums.h"

#ifdef _HAVE_MATLAB_
#include "mex.h"
#endif

/*}}}*/
class SeqVec;

class SeqMat{

	public:
	
		int M,N; 
		double* matrix; 

		/*SeqMat constructors, destructors {{{1*/
		SeqMat();
		SeqMat(int M,int N);
		SeqMat(int M,int N,double sparsity);
		SeqMat(double* serial_mat,int M,int N,double sparsity);
		SeqMat(int M,int N,int connectivity,int numberofdofspernode);
		~SeqMat();
		/*}}}*/
		/*SeqMat specific routines {{{1*/
		void Echo(void);
		#ifdef _HAVE_MATLAB_
		mxArray* ToMatlabMatrix(void);
		#endif
		void Assemble(void);
		double Norm(NormMode norm_type);
		void GetSize(int* pM,int* pN);
		void GetLocalSize(int* pM,int* pN);
		void MatMult(SeqVec* X,SeqVec* AX);
		SeqMat* Duplicate(void);
		double* ToSerial(void);
		void SetValues(int m,int* idxm,int n,int* idxn,double* values,InsMode mode);
		/*}}}*/

};
		
/*API :*/
#ifdef _HAVE_MATLAB_
SeqMat*  MatlabMatrixToSeqMat(const mxArray* dataref);
#endif

#endif //#ifndef _SEQMAT_H_
